package gov.va.vinci.dart.dms.db;

import java.util.List;

import gov.va.vinci.dart.dms.biz.Document;

public interface DocumentDAO {

	void save(final Document document);
	void delete(final Document document);
	Document findById(final int documentId);
	List<Document> listAll();
	List<Document> listVersionsById(final int documentId);
	List<Document> listByContentId(final int contentId);
	List<Document> listByRepositoryId(final int repositoryId);
	List<Document> listByRequestAndNonNullContentId(final int requestId, final int contentId);
	int countRequestAndNonNullContentId(final int requestId, final int contentId);
	List<Document> listVersionsByReqIdandTemplIdandContId(int requestId, int templateId, int contentId);
	List<Document> listVersionsByReqIdandTemplId(int requestId, int templateId);
	Document findCurrentVersion(final int documentId);
	Document findMostRecentVersion(final int documentId);
	Document findMostRecentSortorder(final int requestId, final int sortorderId, final int contentId);
	String findLocationByDocId(final int documentId);
	String findParticipantNameByDocId(final int documentId);
}


